<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.534718087 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A65AE" />
    <supported-cpuid id="Neoverse-E1" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA65AECPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA65AEINST_RETIRED / $InstructionsPerCycleCortexA65AECPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-A65AE)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA65AECPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA65AESTALL_FRONTEND / $FrontendStalledCyclesCortexA65AECPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA65AECPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA65AESTALL_BACKEND / $BackendStalledCyclesCortexA65AECPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageCortexA65AEINST_SPEC &gt; 0), min(($RetiredInstructionsPercentageCortexA65AEINST_RETIRED / $RetiredInstructionsPercentageCortexA65AEINST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageCortexA65AEBR_RETIRED &gt; 0), min(($BranchDirectPercentageCortexA65AEBR_IMMED_RETIRED / $BranchDirectPercentageCortexA65AEBR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageCortexA65AEBR_RETIRED &gt; 0), min(($BranchReturnPercentageCortexA65AEBR_RETURN_RETIRED / $BranchReturnPercentageCortexA65AEBR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Frontend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA65AEINST_RETIRED &gt; 0), (($BranchMPKICortexA65AEBR_MIS_PRED_RETIRED / $BranchMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Frontend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA65AEBR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA65AEBR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA65AEBR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA65AEINST_RETIRED &gt; 0), (($ITLBMPKICortexA65AEITLB_WALK / $ITLBMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA65AEINST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA65AEL1I_TLB_REFILL / $L1InstructionTLBMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA65AEL1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA65AEITLB_WALK / $ITLBWalkPercentageCortexA65AEL1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA65AEL1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA65AEL1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA65AEL1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA65AEINST_RETIRED &gt; 0), (($L1ICacheMPKICortexA65AEL1I_CACHE_REFILL / $L1ICacheMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA65AEL1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA65AEL1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA65AEL1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA65AEINST_RETIRED &gt; 0), (($DTLBMPKICortexA65AEDTLB_WALK / $DTLBMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA65AEINST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA65AEL1D_TLB_REFILL / $L1DataTLBMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA65AEINST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA65AEL2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA65AEL1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA65AEDTLB_WALK / $DTLBWalkPercentageCortexA65AEL1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA65AEL1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA65AEL1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA65AEL1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA65AEL2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA65AEL2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA65AEL2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA65AEINST_RETIRED &gt; 0), (($L1DCacheMPKICortexA65AEL1D_CACHE_REFILL / $L1DCacheMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA65AEL1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA65AEL1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA65AEL1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA65AEINST_RETIRED &gt; 0), (($L2CacheMPKICortexA65AEL2D_CACHE_REFILL / $L2CacheMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA65AEL2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA65AEL2D_CACHE_REFILL / $L2CacheMissPercentageCortexA65AEL2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA65AEINST_RETIRED &gt; 0), (($L3CacheMPKICortexA65AEL3D_CACHE_REFILL / $L3CacheMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA65AEL3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexA65AEL3D_CACHE_REFILL / $L3CacheMissPercentageCortexA65AEL3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA65AEINST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA65AELL_CACHE_MISS_RD / $LLCacheReadMPKICortexA65AEINST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA65AELL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA65AELL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA65AELL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA65AELL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA65AELL_CACHE_RD - $LLCacheReadHitPercentageCortexA65AELL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA65AELL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA65AEINST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA65AEBR_IMMED_SPEC + $BranchOperationsPercentageCortexA65AEBR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA65AEINST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA65AEINST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA65AECRYPTO_SPEC / $CryptoOperationsPercentageCortexA65AEINST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA65AEINST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA65AELDST_SPEC / $LoadStoreOperationsPercentageCortexA65AEINST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA65AEINST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA65AEVFP_SPEC / $FloatingPointOperationsPercentageCortexA65AEINST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA65AEINST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA65AEASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA65AEINST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA65AELDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA65AELD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA65AELDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA65AELDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA65AEST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA65AELDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A65AE)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA65AEINST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA65AELD_SPEC / $LoadOperationsPercentageCortexA65AEINST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA65AEINST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA65AEST_SPEC / $StoreOperationsPercentageCortexA65AEINST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv8_Cortex_A65AE_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_direct_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_return_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_store_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_direct_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_return_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_crypto_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_E1_metric_ipc" />
    <select-metric id="ARMv8_Neoverse_E1_metric_itlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_load_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_load_store_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Neoverse_E1_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_simd_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_store_percentage" />
</template>
